import {
  PublicKey, 
  Connection, 
  SystemProgram,
  Transaction,
  VersionedTransaction,
  TransactionMessage,
  LAMPORTS_PER_SOL
} from "@solana/web3.js"

import { ApolloWallet }  from 'apollo-wallet'
import "bootstrap/dist/css/bootstrap.min.css";
import { Alert } from "bootstrap";
import "@/assets/styles.css";

window.Alert = Alert;
const connection = new Connection("http://127.0.0.1:8899", "confirmed")
let adresses

const accounts = document.getElementById('accounts')
const accountsSelect = document.getElementById('accountsSelect')
const connectBtn = document.getElementById('connect')
const sendBtn = document.getElementById('sendBtn')
const toAccount = document.getElementById('toBlock')
const to = document.getElementById('to')
const amountBlock = document.getElementById('amountBlock')
const amount = document.getElementById('amount')
const alertSuccess = document.getElementById('alert-success')
const alertDanger = document.getElementById('alert-danger')

function showTransfer() {  
  accounts.classList.remove('hidden')
  sendBtn.classList.remove('hidden')
  toAccount.classList.remove('hidden')
  amountBlock.classList.remove('hidden')
  connectBtn.classList.add('hidden') 
  adresses.forEach(opt => {
    const option = document.createElement('option')
    option.value = opt
    option.textContent = opt
    accountsSelect.appendChild(option)
  });
}

let apolloWallet

async function connect() {
  let app = document.querySelector('input[name="app"]:checked').value;
  apolloWallet = new ApolloWallet(app)
  apolloWallet.connect()
  adresses = await apolloWallet.getAdresses()
  showTransfer()
}

async function send() { 
  const toPubkey = new PublicKey(to.value);
  const fromPubkey = new PublicKey(accountsSelect.value);
  const amountInSol = Number(amount.value);
  const lamports = amountInSol * LAMPORTS_PER_SOL;  
  const instruction = SystemProgram.transfer({
      fromPubkey,
      toPubkey,
      lamports,
  });
  const instructions = [instruction];    
  const { blockhash } = await connection.getLatestBlockhash()
  let txData, signer
  let versioned = false
  // Example legacy or versioned transaction
  if (versioned) {
    const messageV0 = new TransactionMessage({
      payerKey: fromPubkey,
      recentBlockhash: blockhash,
      instructions: instructions,
    }).compileToV0Message();
    const tx = new VersionedTransaction(messageV0);
    let txBytes = tx.serialize({
      requireAllSignatures: false,
      verifySignatures: false,
    }) 
    txData = Array.from(txBytes)
    signer = accountsSelect.value   

  } else {
    const tx = new Transaction().add(...instructions);
    tx.recentBlockhash = blockhash;
    tx.feePayer = fromPubkey;
    let txBytes = tx.serialize({
      requireAllSignatures: false,
      verifySignatures: false,
    });
    txData = Array.from(txBytes)
    signer = accountsSelect.value   
  }
  //send transaction to sign
  console.log("txData", txData)
  const txBytes = await apolloWallet.signTransaction(txData, signer)
  await run(txBytes)
}

async function run(txBytes) {
  try {    
    const txSig = await connection.sendRawTransaction(txBytes)
    console.log("✅ Signature:", txSig)
    amount.value = ""
    to.value = ""
    alertSuccess.classList.add('show')
  } catch(err) {
    alertDanger.classList.add('show')
  }
  
}

document.getElementById("connect").addEventListener("click", connect);
document.getElementById("sendBtn").addEventListener("click", send);