import { fileURLToPath, URL } from "url";

import { defineConfig } from "vite";
import { nodePolyfills } from 'vite-plugin-node-polyfills'

// https://vitejs.dev/config/
export default defineConfig({
  plugins: [
    nodePolyfills()
  ],
  resolve: {
    alias: {
      "@": fileURLToPath(new URL("./src", import.meta.url)),
    },
  },
  server: {
    port: 3005,
    //historyApiFallback: true
  },  
  optimizeDeps: { // 👈 optimizedeps
    esbuildOptions: {
      target: "es2020", 
      // Node.js global to browser globalThis
      define: {
        global: 'globalThis'
      },
      supported: { 
        bigint: true 
      },
    }
  }, 

  build: {
    target: ["es2020"], 
    /*
    rollupOptions: {
      output: {
        manualChunks: {}, // Disable manual chunking
        entryFileNames: 'app.js', // Name of your main JS file
        assetFileNames: 'app.[ext]', // Name for other assets (e.g., app.css)
      },
    },*/
    cssCodeSplit: false,
  },
});
